# Sensor Tracking Consistency Test Report

## Test Overview

**Test Date**: December 2025  
**Test Purpose**: Comparative analysis of sensor tracking consistency at high polling rates  
**Test Products**:
- Mambasnake M5 Ultra (PAW3950 Sensor)
- Logitech GPX2 (HERO 2 Sensor)

---

## Test Environment

### Hardware Configuration
- **Polling Rate**: 8,000Hz (8kHz)
- **Test DPI Levels**: 400, 800, 1600
- **Movement Velocity**: 0.5 m/s (constant speed)
- **Test Duration**: 20ms tracking window per sample
- **Sampling Interval**: 0.1250ms (125 microseconds)

### Test Equipment
- **Motion Platform**: Precision linear actuator
- **Surface**: Standard gaming mousepad
- **Environmental Control**: Temperature 22°C, Humidity 45%

---

## Test Methodology

### Tracking Consistency Analysis

**Test Principle**:  
At ultra-high polling rates (8kHz), sensor consistency becomes critical. This test measures the deviation in reported counts per update interval during constant-velocity movement.

**Measurement Method**:
1. Move mouse at constant velocity (0.5 m/s)
2. Record sensor counts at each polling interval
3. Calculate standard deviation as percentage of mean counts
4. Identify maximum peak deviation from theoretical value

**Evaluation Criteria**:
- **Excellent**: < 1.0% average deviation
- **Good**: 1.0% - 1.5% average deviation  
- **Acceptable**: 1.5% - 2.0% average deviation
- **Poor**: > 2.0% average deviation

---

## Test Results

### Summary Table

| DPI | Sensor | Avg Deviation | Max Peak Deviation | Tracking Status |
|-----|--------|---------------|-------------------|----------------|
| 400 | PAW3950 (M5 Ultra) | 0.79% | 2.07% | Perfectly Consistent |
| 400 | HERO 2 (GPX2) | 0.88% | 2.21% | Perfectly Consistent |
| 800 | PAW3950 (M5 Ultra) | 0.76% | 2.87% | Perfectly Consistent |
| 800 | HERO 2 (GPX2) | 0.93% | 2.44% | Perfectly Consistent |
| 1600 | PAW3950 (M5 Ultra) | 0.80% | 2.07% | Perfectly Consistent |
| 1600 | HERO 2 (GPX2) | 0.82% | 2.52% | Perfectly Consistent |


### Detailed Analysis by DPI Level

#### 400 DPI Test Results

**PAW3950 (M5 Ultra)**
- Average Deviation: 0.79%
- Max Peak Deviation: 2.07%
- Status: Perfectly Consistent

**HERO 2 (GPX2)**
- Average Deviation: 0.88%
- Max Peak Deviation: 2.21%
- Status: Perfectly Consistent

#### 800 DPI Test Results

**PAW3950 (M5 Ultra)**
- Average Deviation: 0.76%
- Max Peak Deviation: 2.87%
- Status: Perfectly Consistent

**HERO 2 (GPX2)**
- Average Deviation: 0.93%
- Max Peak Deviation: 2.44%
- Status: Perfectly Consistent

#### 1600 DPI Test Results

**PAW3950 (M5 Ultra)**
- Average Deviation: 0.80%
- Max Peak Deviation: 2.07%
- Status: Perfectly Consistent

**HERO 2 (GPX2)**
- Average Deviation: 0.82%
- Max Peak Deviation: 2.52%
- Status: Perfectly Consistent

---

## Key Findings

### 1. Sensor Performance Comparison

**PAW3950 (M5 Ultra)**
- Excellent consistency across all DPI levels
- Average deviation consistently below 1%
- Stable performance at 8kHz polling rate
- Minimal jitter in high-speed tracking

**HERO 2 (GPX2)**
- Excellent consistency across all DPI levels
- Average deviation consistently below 1%
- Stable performance at 8kHz polling rate
- Comparable performance to PAW3950

### 2. Polling Rate Impact

At 8,000Hz polling rate:
- Both sensors maintain excellent tracking consistency
- Sub-1% deviation indicates professional-grade precision
- No significant performance degradation at higher DPI levels
- Both sensors are suitable for competitive gaming

### 3. DPI Scaling Analysis

**400 DPI** (Precision Mode)
- Lowest absolute count values per interval
- Highest relative consistency
- Ideal for tactical shooters requiring micro-adjustments

**800 DPI** (Balanced Mode)
- Optimal balance between precision and speed
- Consistent performance across both sensors
- Most popular DPI for professional esports

**1600 DPI** (High Speed Mode)
- Higher count values per interval
- Maintained excellent consistency
- Suitable for fast-paced gaming scenarios

---

## Technical Insights

### Why 8kHz Polling Rate Matters

1. Reduced Input Latency: 0.125ms update interval vs 1ms at 1kHz
2. Smoother Cursor Movement: More frequent position updates
3. Better Micro-Adjustments: Finer control in precision scenarios
4. Competitive Advantage: Measurable improvement in reaction-based games

### Sensor Consistency Importance

Low deviation percentages indicate:
- Predictable cursor behavior
- Reduced "pixel skipping" artifacts
- Better muscle memory development
- More reliable aim in competitive scenarios

---

## Recommendations

**For Competitive Gamers**:
- Both sensors provide professional-grade tracking consistency
- Choose based on other factors (shape, weight, features)
- 8kHz polling rate provides measurable advantage

**For General Users**:
- Both sensors exceed requirements for daily use
- Consistency differences are imperceptible in normal usage
- Focus on ergonomics and overall mouse design

**DPI Selection Guide**:
- **400 DPI**: Tactical shooters, precision work
- **800 DPI**: All-around gaming, most versatile
- **1600 DPI**: Fast-paced games, large monitors

---

## Data Appendix

### Complete Test Data Package

All test data has been packaged and uploaded to cloud storage:

[Download Complete Test Data Package](https://hawk-serp-1251490959.cos.ap-singapore.myqcloud.com/pseo-cbb/mambasnake_lab_20251225_164343_758606.zip)

**Package Contents**:
- `sensor_tracking_consistency.csv` - Complete test data
- `sensor_consistency_comparison.png` - Tracking consistency chart
- `Sensor_Tracking_Consistency_Report.md` - This report

**Data Field Descriptions**:
- **DPI**: Dots per inch setting
- **Sensor**: Sensor model name
- **Avg Deviation (%)**: Standard deviation as percentage of mean
- **Max Peak Deviation (%)**: Maximum single-sample deviation
- **Tracking Status**: Qualitative assessment

---

## Test Declaration

This test is based on controlled laboratory measurements using precision equipment. Results represent ideal conditions and may vary in real-world usage.

**Testing Institution**: Mambasnake Laboratory  
**Data Validity Period**: December 2025  
**Contact**: For raw data or detailed test methods, please contact Mambasnake Laboratory

---

*All data in this report is based on actual testing and has not received any manufacturer sponsorship or financial consideration.*
